/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
// Then modified to generalise to any number of sides .

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

//Borrowed from https://www.shadertoy.com/view/4dX3WN

vec3 rgb2hsv(vec3 rgb)
{
	float Cmax = max(rgb.r, max(rgb.g, rgb.b));
	float Cmin = min(rgb.r, min(rgb.g, rgb.b));

   float delta = Cmax - Cmin;

	vec3 hsv = vec3(0., 0., Cmax);
	
	if (Cmax > Cmin)
	{
		hsv.y = delta / Cmax;

		if (rgb.r == Cmax)
			hsv.x = (rgb.g - rgb.b) / delta;
		else
		{
			if (rgb.g == Cmax)
				hsv.x = 2. + (rgb.b - rgb.r) / delta;
			else
				hsv.x = 4. + (rgb.r - rgb.g) / delta;
		}
		hsv.x = fract(hsv.x / 6.);
	}
	return hsv;
}

float chromaKey(vec3 color)
{
	vec3 backgroundColor = vec3(0.157, 0.576, 0.129);
	vec3 weights = vec3(4., 1., 2.);

	vec3 hsv = rgb2hsv(color);
	vec3 target = rgb2hsv(backgroundColor);
	float dist = length(weights * (target - hsv));
	return 1. - clamp(3. * dist - 1.5, 0., 1.);
}

//based on Mario scan line:

vec3 Scanline(vec3 color, vec2 uv)
{
   float a = 3.14 * 240.0 * ( uv.y + 0.008 * iGlobalTime );
   float b = 3.14 * 640.0 *   uv.x;
   float scanline  = clamp ( 0.05*cos(a) + 0.95, 0.0, 1.0 );
   float grille    = clamp ( 1.50*cos(b), 0.0, 1.0 ) * 0.15 + 0.85;    
   return color * scanline * grille * 1.2;
}

//from tv flickering: https://www.shadertoy.com/view/4tSGzy

float rand(vec2 seed)
 {
   float dotResult = dot(seed.xy, vec2(12.9898,78.233));
   float sin = sin(dotResult) * 43758.5453;
   return fract(sin);
 }

//mine:

vec3 makeBlue(vec3 i)
 {
   return vec3(0.0, 0.0, (i.r + i.g + i.b)/3.0);
 }

vec3 edgeSample(vec2 uv)
 {    
   if(uv.x > 1.0) return vec3(0.0);
   if(uv.x < 0.0) return vec3(0.0);
   if(uv.y > 1.0) return vec3(0.0);
   if(uv.y < 0.0) return vec3(0.0);
   vec3 c = texture2D(iChannel0,uv).rgb;
   return mix ( c, vec3(0.0), chromaKey(c) );
 }

vec3 a(vec2 uv, float y, vec2 emmitPoint)
 {
   uv -= emmitPoint;
   y  -= emmitPoint.y;

   float ym = y;

   vec2 centre = vec2(0.0, y);
   vec2 scale = vec2(2.0, 2.0 * (0.5/y));

   vec2 n = (uv - centre)*scale * vec2(1.0,-1.0);
   
   vec2 n2 = vec2(n.x * (1.0/(1.0-n.y)), n.y);
   
   vec2 uv2 = n2 * vec2(1.0,-1.0) / scale + centre;
   
   uv2 += emmitPoint;
   y += emmitPoint.y;
   
   uv2.y = y;
   
   vec3 c = edgeSample(uv2);
   
   c *= clamp(((ym+0.2)-uv.y)/ym, 0.0, 1.0);
   
   return c;
 }

void main ( void )
 {
   vec2 uv = gl_FragCoord.xy / iResolution.xy;
   uv.y = 1.0 - uv.y; // Inverted for VGHD, TheEmu.
   uv = (uv - vec2(0.5,0.0)) * 1.5 + vec2(0.5,-0.5);

   vec2 uvFlicker = uv;
   
   //flicker
   uvFlicker.x += rand(vec2(0,uv.y)*(iGlobalTime)) * 0.005;
   uvFlicker.y += rand(vec2(0,uv.x)*(iGlobalTime)) * 0.005;
    
   vec3 c = vec3(0.0);

   float inc = 0.2;
   vec2 projectionPoint = vec2(0.0,-0.5);
   
   for(float i=0.0;i<=1.0;i += 0.2){
      c += a(uv, i, projectionPoint) * inc * 3.0;
   }
   
   c += Scanline(edgeSample(uvFlicker)*1.5, uv);
   c = makeBlue(c);

   gl_FragColor = vec4 ( c, 1.0 );
 }